# Overclock Logo Pack

## Contents

### SVG Files (in `/svg`)

**Logo Mark (Icon Only)**
- `overclock-mark-color.svg` - Orange mark, transparent background (primary)
- `overclock-mark-white.svg` - White mark for dark/colored backgrounds
- `overclock-mark-black.svg` - Black mark for light backgrounds

**Full Logo (Mark + Wordmark)**
- `overclock-full-dark-bg.svg` - Orange mark + white text (use on dark backgrounds)
- `overclock-full-light-bg.svg` - Orange mark + black text (use on light backgrounds)
- `overclock-full-white.svg` - All white (use on dark/colored backgrounds)
- `overclock-full-black.svg` - All black (use on light backgrounds)

**Favicon**
- `favicon.svg` - Scalable favicon


### PNG Files (in `/png`)

**Logo Mark - Color (Orange)**
- `overclock-mark-color-512.png` (512×512)
- `overclock-mark-color-256.png` (256×256)
- `overclock-mark-color-128.png` (128×128)
- `overclock-mark-color-64.png` (64×64)
- `overclock-mark-color-32.png` (32×32)

**Logo Mark - White**
- `overclock-mark-white-512.png` (512×512)

**Logo Mark - Black**
- `overclock-mark-black-512.png` (512×512)

**Full Logos (720×160)**
- `overclock-full-dark-bg.png` - Orange mark + white text
- `overclock-full-light-bg.png` - Orange mark + black text
- `overclock-full-white.png` - All white
- `overclock-full-black.png` - All black

**Favicons**
- `apple-touch-icon-180.png` (180×180)
- `favicon-32.png` (32×32)
- `favicon-16.png` (16×16)


## Usage Guidelines

### Clear Space
Maintain minimum clear space equal to the height of the logo mark around all sides.

### Minimum Size
- Logo Mark: 24px minimum
- Full Logo: 120px width minimum

### Color Values
- Signal Orange: `#FF6B35`
- Inner Rectangle Opacity: 30%

### Do's
✓ Use on dark backgrounds (preferred)
✓ Use on light backgrounds with appropriate version
✓ The mark can be used standalone when space is limited

### Don'ts
✗ Never rotate, distort, or apply effects
✗ Never change the orange accent color
✗ Never place on busy backgrounds or low-contrast surfaces
✗ Never alter the proportions


## Custom Sizes

Need a different size? SVG files can be exported to PNG at any resolution using:
- Figma (import SVG, export as PNG)
- Adobe Illustrator
- Inkscape (free)
- Online converters (svgtopng.com)


## Font Requirement

The wordmark uses **Inter** (weight: 600, letter-spacing: -0.02em).
Download from: https://fonts.google.com/specimen/Inter


---
© Overclock Technologies
